Ext.data.JsonP.sol_NamespaceManager({"tagname":"class","name":"sol.NamespaceManager","autodetected":{},"files":[{"filename":"lib_Class.js","href":"lib_Class.html#sol-NamespaceManager"}],"singleton":true,"author":[{"tagname":"author","name":"Nils Mosbach, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloall":true,"members":[{"name":"ns","tagname":"method","owner":"sol.NamespaceManager","id":"method-ns","meta":{}}],"alternateClassNames":[],"aliases":{},"id":"class-sol.NamespaceManager","short_doc":"Namespaces allow organizing classes and objects in hierarchical structures. ...","classIcon":"icon-singleton","superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/lib_Class.html#sol-NamespaceManager' target='_blank'>lib_Class.js</a></div></pre><div class='doc-contents'><p>Namespaces allow organizing classes and objects in hierarchical structures.</p>\n\n<p>There are several namespace that are reservered by elo and should not be used\nby custom scripts.</p>\n\n<pre><code>elo\nsol\n</code></pre>\n\n<p>It is recommended that partner implementions use a namespace that matches their\nname. e.g. a company with the name \"Software implementation and it services\" should\nchoose a namespace like</p>\n\n<pre><code>siis\n</code></pre>\n\n<p>Without the use of <a href=\"#!/api/sol-static-method-ns\" rel=\"sol-static-method-ns\" class=\"docClass\">sol.ns</a> namespace can be created as followed:</p>\n\n<pre><code>var sol = sol || {};\nsol.common = sol.common || {};\nsol.common.logging = sol.common.logging || {};\n</code></pre>\n\n<p><a href=\"#!/api/sol-static-method-ns\" rel=\"sol-static-method-ns\" class=\"docClass\">sol.ns</a> simplifies that process to one single line.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-ns\" rel=\"sol-static-method-ns\" class=\"docClass\">sol.ns</a>('sol.common.logging');\n</code></pre>\n\n<h1>Examples</h1>\n\n<p>following example shows the creation of configuration object in the namespace \"sol.invoice.configuration\".</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-ns\" rel=\"sol-static-method-ns\" class=\"docClass\">sol.ns</a>('sol.invoice.configuration');\nsol.invoice.configuration.Workflow = {\n  wfName: 'approval process'\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-ns' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.NamespaceManager'>sol.NamespaceManager</span><br/><a href='source/lib_Class.html#sol-NamespaceManager-method-ns' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.NamespaceManager-method-ns' class='name expandable'>ns</a>( <span class='pre'>namespace</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new namespace thanks to a given string. ...</div><div class='long'><p>Creates a new namespace thanks to a given string.\nNew namespace should always be created usind <a href=\"#!/api/sol-static-method-ns\" rel=\"sol-static-method-ns\" class=\"docClass\">sol.ns</a>.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-ns\" rel=\"sol-static-method-ns\" class=\"docClass\">sol.ns</a>('sol.common');\n</code></pre>\n\n<p>Please refer to <a href=\"#!/api/sol.NamespaceManager\" rel=\"sol.NamespaceManager\" class=\"docClass\">sol.NamespaceManager</a> for more information.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>namespace</span> : String<div class='sub-desc'><p>namespace as string.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>returns the last instance of the created namespace object.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloall":true,"singleton":true}});